/*
 * Decompiled with CFR 0.152.
 */
package com.tdv.nuitrack.sdk;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.ResolveInfo;
import android.os.IBinder;
import android.os.RemoteException;
import com.tdv.nuitrack.sdk.INuitrackManager;
import java.io.File;

public class Nuitrack {
    public static final int INIT_NUITRACK_SERVICE_OK = 0;
    public static final int INIT_NUITRACK_SERVICE_NOT_INSTALLED = 1;
    public static final int INIT_NUITRACK_RESOURCES_NOT_INSTALLED = 2;
    public static final int INIT_NUITRACK_SERVICE_ERROR = 3;
    public static final int INIT_NUITRACK_SERVICE_BAN = 4;
    public static final String NuitrackService = "com.tdv.nuitrack.sdk.NuitrackService";
    private static Context mContext = null;
    private static NuitrackCallback mNuitrackCallback = null;
    private static INuitrackManager nuitrackManager = null;
    private static ServiceConnection mConnection = new ServiceConnection(){

        public void onServiceDisconnected(ComponentName name) {
            nuitrackManager = null;
        }

        public void onServiceConnected(ComponentName name, IBinder service) {
            block11: {
                nuitrackManager = INuitrackManager.Stub.asInterface(service);
                try {
                    String[] libraryList;
                    if (!nuitrackManager.init()) {
                        if (mNuitrackCallback != null) {
                            mNuitrackCallback.onInitFailure(4);
                        }
                        mContext.unbindService(mConnection);
                        return;
                    }
                    String dataPath = nuitrackManager.getDataPath();
                    File dataDir = new File(dataPath);
                    if (!dataDir.isDirectory()) {
                        if (mNuitrackCallback != null) {
                            mNuitrackCallback.onInitFailure(2);
                        }
                        mContext.unbindService(mConnection);
                        return;
                    }
                    String libraryPath = nuitrackManager.getLibraryPath();
                    for (String library : libraryList = nuitrackManager.getLibraryList()) {
                        try {
                            System.load(libraryPath + "/" + library);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        catch (UnsatisfiedLinkError e) {
                            e.printStackTrace();
                        }
                    }
                    Nuitrack.initAndroidApp(mContext);
                    if (mNuitrackCallback != null) {
                        mNuitrackCallback.onInitSuccess(mContext);
                    }
                }
                catch (RemoteException e) {
                    if (mNuitrackCallback == null) break block11;
                    mNuitrackCallback.onInitFailure(3);
                }
            }
            mContext.unbindService(mConnection);
        }
    };

    public static void init(Context context, NuitrackCallback callback) {
        mContext = context;
        mNuitrackCallback = callback;
        Nuitrack.NuitrackServiceIntent();
    }

    private static void NuitrackServiceIntent() {
        Intent nuitrackIntent = new Intent(NuitrackService);
        ResolveInfo resolveInfo = mContext.getPackageManager().resolveService(nuitrackIntent, 0);
        if (resolveInfo == null) {
            if (mNuitrackCallback != null) {
                mNuitrackCallback.onInitFailure(1);
            }
            return;
        }
        nuitrackIntent.setPackage(resolveInfo.serviceInfo.packageName);
        if (!mContext.bindService(nuitrackIntent, mConnection, 1)) {
            if (mNuitrackCallback != null) {
                mNuitrackCallback.onInitFailure(1);
            }
            return;
        }
    }

    private static native void initAndroidApp(Context var0);

    public static interface NuitrackCallback {
        public void onInitSuccess(Context var1);

        public void onInitFailure(int var1);
    }
}

