/*
 * Decompiled with CFR 0.152.
 */
package org.videolan;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.videolan.CacheDir;
import org.videolan.Logger;
import org.videolan.bdjo.AppCache;

class VFSCache {
    private String cacheRoot = null;
    private String vfsRoot = null;
    private String fontRoot = null;
    private int vfsRootLength = 0;
    private static final String jarDir = "BDMV" + File.separator + "JAR" + File.separator;
    private static final String fontDir = "BDMV" + File.separator + "AUXDATA" + File.separator;
    private static final Logger logger = Logger.getLogger(VFSCache.class.getName());

    protected static VFSCache createInstance() {
        VFSCache cache = new VFSCache();
        try {
            cache.init();
        }
        catch (IOException e) {
            return null;
        }
        return cache;
    }

    private VFSCache() {
    }

    private void init() throws IOException {
        String disable = System.getProperty("org.videolan.vfscache");
        if (disable != null && disable.equals("NO")) {
            logger.error("Cache disabled !");
            throw new IOException();
        }
        this.cacheRoot = CacheDir.create("VFSCache").getPath() + File.separator;
        this.fontRoot = CacheDir.create("Font").getPath() + File.separator;
        this.vfsRoot = System.getProperty("bluray.vfs.root");
        if (!this.vfsRoot.endsWith(File.separator)) {
            this.vfsRoot = this.vfsRoot + File.separator;
        }
        this.vfsRootLength = this.vfsRoot.length();
        new File(this.cacheRoot + jarDir).mkdirs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean copyStream(InputStream inStream, String dstPath) {
        FileOutputStream outStream = null;
        byte[] buffer = new byte[65536];
        IOException exception = null;
        try {
            int length;
            outStream = new FileOutputStream(dstPath);
            while ((length = inStream.read(buffer)) > 0) {
                ((OutputStream)outStream).write(buffer, 0, length);
            }
        }
        catch (IOException e) {
            exception = e;
        }
        finally {
            block15: {
                if (outStream != null) {
                    try {
                        ((OutputStream)outStream).close();
                    }
                    catch (IOException e) {
                        if (exception != null) break block15;
                        exception = e;
                    }
                }
            }
        }
        if (exception != null) {
            logger.error("Error caching to " + dstPath + ": " + exception);
            new File(dstPath).delete();
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean copyFile(String srcPath, String dstPath) {
        FileInputStream inStream = null;
        IOException exception = null;
        boolean result = false;
        try {
            inStream = new FileInputStream(srcPath);
            result = this.copyStream(inStream, dstPath);
        }
        catch (IOException e) {
            exception = e;
        }
        finally {
            block14: {
                if (inStream != null) {
                    try {
                        ((InputStream)inStream).close();
                    }
                    catch (IOException e) {
                        if (exception != null) break block14;
                        exception = e;
                    }
                }
            }
        }
        if (exception != null) {
            logger.error("Error caching " + srcPath + ": " + exception);
            new File(dstPath).delete();
            return false;
        }
        return result;
    }

    private void copyJarFile(String name) {
        String srcPath = this.vfsRoot + jarDir + name;
        String dstPath = this.cacheRoot + jarDir + name;
        File dstFile = new File(dstPath);
        if (dstFile.exists()) {
            return;
        }
        this.copyFile(srcPath, dstPath);
        logger.info("cached " + name);
    }

    private void copyJarDir(String name) {
        new File(this.cacheRoot + jarDir + name).mkdirs();
        File[] files = new File(this.vfsRoot + jarDir + name).listFiles();
        for (int i = 0; i < files.length; ++i) {
            File file = files[i];
            String relPath = name + File.separator + files[i].getName();
            if (file.isDirectory()) {
                this.copyJarDir(relPath);
                continue;
            }
            this.copyJarFile(relPath);
        }
        logger.info("cached " + name);
    }

    protected synchronized void add(AppCache[] appCaches) {
        for (int i = 0; i < appCaches.length; ++i) {
            if (appCaches[i].getType() == 1) {
                this.copyJarFile(appCaches[i].getRefToName() + ".jar");
                continue;
            }
            if (appCaches[i].getType() == 2) {
                this.copyJarDir(appCaches[i].getRefToName());
                continue;
            }
            logger.error("unknown AppCache type " + appCaches[i].getType());
        }
    }

    protected synchronized File addFont(String fontFile) {
        new File(this.fontRoot + fontDir).mkdirs();
        String srcPath = this.vfsRoot + fontDir + fontFile;
        String dstPath = this.fontRoot + fontDir + fontFile;
        File dstFile = new File(dstPath);
        if (dstFile.exists()) {
            return dstFile;
        }
        if (!this.copyFile(srcPath, dstPath)) {
            return null;
        }
        logger.info("cached font " + fontFile);
        return dstFile;
    }

    protected synchronized File addFont(InputStream is) {
        new File(this.fontRoot).mkdirs();
        File tmpFile = null;
        for (int i = 0; i < 100; ++i) {
            tmpFile = new File(this.fontRoot + System.nanoTime() + ".otf");
            try {
                tmpFile = new File(tmpFile.getCanonicalPath());
                if (!tmpFile.exists()) {
                    break;
                }
            }
            catch (IOException ex) {
                logger.error("got " + ex);
            }
            tmpFile = null;
        }
        if (tmpFile == null) {
            logger.error("error creating temporary font file");
            return null;
        }
        if (!this.copyStream(is, tmpFile.getPath())) {
            return null;
        }
        logger.info("cached font stream to file " + tmpFile.getPath());
        return tmpFile;
    }

    protected synchronized boolean add(String vpFile, String budaFile) {
        String srcPath = System.getProperty("bluray.bindingunit.root") + File.separator + budaFile;
        String dstPath = this.cacheRoot + vpFile;
        return this.copyFile(srcPath, dstPath);
    }

    public synchronized String map(String absPath) {
        if (!absPath.startsWith(this.vfsRoot)) {
            return absPath;
        }
        String cachePath = this.cacheRoot + absPath.substring(this.vfsRootLength);
        if (!new File(cachePath).exists()) {
            return absPath;
        }
        logger.info("using cached " + cachePath);
        return cachePath;
    }
}

