/*
 * Decompiled with CFR 0.152.
 */
package org.dvb.user;

import java.util.Iterator;
import java.util.LinkedList;

public class Preference {
    private String name;
    private LinkedList values = new LinkedList();

    protected Preference() {
    }

    public Preference(String name, String value) {
        this.name = name;
        if (value != null) {
            this.values.add(value);
        }
    }

    public Preference(String name, String[] value) {
        this.name = name;
        for (int i = 0; i < value.length; ++i) {
            this.values.add(value[i]);
        }
    }

    public void add(String value) {
        this.values.remove(value);
        this.values.add(value);
    }

    public void add(String[] value) {
        for (int i = 0; i < value.length; ++i) {
            this.add(value[i]);
        }
    }

    public void add(int position, String value) {
        this.values.remove(value);
        if (position < 0) {
            position = 0;
        } else if (position > this.values.size()) {
            position = this.values.size();
        }
        this.values.add(position, value);
    }

    public String[] getFavourites() {
        if (this.values.isEmpty()) {
            return new String[0];
        }
        return (String[])this.values.toArray();
    }

    public String getMostFavourite() {
        if (this.values.isEmpty()) {
            return null;
        }
        return (String)this.values.get(0);
    }

    public String getName() {
        return this.name;
    }

    public int getPosition(String value) {
        return this.values.indexOf(value);
    }

    public boolean hasValue() {
        return !this.values.isEmpty();
    }

    public void remove(String value) {
        this.values.remove(value);
    }

    public void removeAll() {
        this.values.clear();
    }

    public void setMostFavourite(String value) {
        this.values.remove(value);
        this.values.addFirst(value);
    }

    public String toString() {
        String result = "Preference:" + this.name + "[";
        String comma = "";
        Iterator it = this.values.iterator();
        while (it.hasNext()) {
            result = result + comma + (String)it.next();
            comma = ",";
        }
        result = result + ']';
        return result;
    }
}

